#include "POF/Gradient_generator.h"

double ccon_gradient[n_label][MAX_n_class][MAX_batch_size] {};
double test_case_ccon_gradient[n_label][MAX_n_class][MAX_n_internal_test_case] {};

void free_list(double list[]) {
	delete[] list;
}

void flatten_ccon_gradient(int n_label, int batch_size, int n_class, double ccon_gradient_list[]) {
	for (int i = 0; i < n_label; i++) {
		for (int j = 0; j < batch_size; j++) {
			for (int k = 0; k < n_class; k++) {
				ccon_gradient_list[i*batch_size*n_class + j*n_class + k] = ccon_gradient[i][k][j];
			}
		}
	}
}

void flatten_test_case_ccon_gradient(int n_label, int n_internal_test_case, int n_class, double test_case_ccon_gradient_list[]) {
	for (int i = 0; i < n_label; i++) {
		for (int j = 0; j < n_internal_test_case; j++) {
			for (int k = 0; k < n_class; k++) {
				test_case_ccon_gradient_list[i*n_internal_test_case*n_class + j*n_class + k] = test_case_ccon_gradient[i][k][j];
			}
		}
	}
}

void calc_grad_ccon(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double ccon_gradient_list[]) {

	for (int pm = 0; pm < n_label; pm++) {
		for (int j = 0; j < nn_data->batch_size; j++) {
			double approx_loss_class[nn_data->n_class];
			double expsum = 0;
			
			for (int i = 0; i < nn_data->n_class; i++) {
				int tmp = nn_data->normalclass[pm][j]; // KKY: check
				nn_data->normalclass[pm][j] = i;
				// KKY: assumption:normaltable, posterior are already set.
				approx_loss_class[i] = calc_approx_loss(nn_data, indata, user_parameter);
				expsum += exp(nn_data->ccon_w[pm][i][j]);
				nn_data->normalclass[pm][j] = tmp;
			}
			for (int i = 0; i < nn_data->n_class; i++) {
				ccon_gradient[pm][i][j] = 0;
				for (int k = 0; k < nn_data->n_class; k++) {
					if (k == i)
						ccon_gradient[pm][i][j] += approx_loss_class[k] * (exp(nn_data->ccon_w[pm][k][j]) / expsum);
					ccon_gradient[pm][i][j] += -approx_loss_class[k] * (exp(nn_data->ccon_w[pm][k][j]) * exp(nn_data->ccon_w[pm][i][j]) / expsum / expsum);
				}
				// NO_UPDATE
			}
		}
	}

	flatten_ccon_gradient(n_label, nn_data->batch_size, nn_data->n_class, ccon_gradient_list);
}

void calc_grad_test_case_ccon(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double test_case_ccon_gradient_list[]) {
	
	double xi = user_parameter->xi;
	int n_rank = user_parameter->n_rank;
	int n_internal_test_case = nn_data->n_internal_test_case;
	int n_class = nn_data->n_class;
	
	Indata *new_indata(new Indata);
	*new_indata = *indata;
	// memcpy(new_indata, indata, sizeof(*indata));

	double main_approxloss = calc_approx_loss(nn_data, indata, user_parameter);

	for (int pm = 0; pm < n_label; pm++) {
		double plusoneone_approxloss[5][10], plusone_minusxi_approxloss[5][10], plusone_plusxi_approxloss[5][10], minusoneone_approxloss[5][10], minusone_minusxi_approxloss[5][10], minusone_plusxi_approxloss[5][10];
		for (int i = 0; i < n_rank; i++) {
			for (int j = 0; j < n_class; j++) {
				// +(1,1)
				new_indata->normaltable[pm][i][j][0]++;
				new_indata->normaltable[pm][i][j][1]++;
				set_posterior(nn_data, user_parameter, new_indata);
				plusoneone_approxloss[i][j] = calc_approx_loss(nn_data, new_indata, user_parameter);
				// +(1,0)
				new_indata->normaltable[pm][i][j][1]--;
				set_posterior(nn_data, user_parameter, new_indata);
				plusone_minusxi_approxloss[i][j] = calc_approx_loss(nn_data, new_indata, user_parameter);
				// +(0,1)
				new_indata->normaltable[pm][i][j][0]--;
				new_indata->normaltable[pm][i][j][1]++;
				set_posterior(nn_data, user_parameter, new_indata);
				plusone_plusxi_approxloss[i][j] = calc_approx_loss(nn_data, new_indata, user_parameter);
				
				new_indata->normaltable[pm][i][j][1]--;
				
				// -(0,1)
				if (new_indata->normaltable[pm][i][j][1]) {
					new_indata->normaltable[pm][i][j][1]--;
					set_posterior(nn_data, user_parameter, new_indata);
					minusone_plusxi_approxloss[i][j] = calc_approx_loss(nn_data, new_indata, user_parameter);
					new_indata->normaltable[pm][i][j][1]++;
				}
				// -(1,0)
				if (new_indata->normaltable[pm][i][j][0]) {
					new_indata->normaltable[pm][i][j][0]--;
					set_posterior(nn_data, user_parameter, new_indata);
					minusone_minusxi_approxloss[i][j] = calc_approx_loss(nn_data, new_indata, user_parameter);
					new_indata->normaltable[pm][i][j][0]++;
				}
				// -(1,1)
				if (new_indata->normaltable[pm][i][j][0] && new_indata->normaltable[pm][i][j][1]) {
					new_indata->normaltable[pm][i][j][0]--;
					new_indata->normaltable[pm][i][j][1]--;
					set_posterior(nn_data, user_parameter, new_indata);
					minusoneone_approxloss[i][j] = calc_approx_loss(nn_data, new_indata, user_parameter);
				}
			}				
		}

		// it_gradient_debugging_5: sample weight new
		// double gradient_sum[2][3] = {};
		for (int j = 0; j < n_internal_test_case; j++) {
			double expsum = 0;
			for (int i = 0; i < n_class; i++) expsum += exp(nn_data->test_case_ccon_w[pm][i][j]);
			for (int i = 0; i < n_class; i++) {
				test_case_ccon_gradient[pm][i][j] = 0;
				for (int k = 0; k < n_class; k++) {
					//calculate expsum for +-xi
					double mxi_expsum = expsum + exp(nn_data->test_case_ccon_w[pm][k][j] - xi) - exp(nn_data->test_case_ccon_w[pm][k][j]);
					double pxi_expsum = expsum + exp(nn_data->test_case_ccon_w[pm][k][j] + xi) - exp(nn_data->test_case_ccon_w[pm][k][j]);
					if (indata->normaltable_eff[pm][k][j][0] && indata->normaltable_eff[pm][k][j][1]) {
						//(1,1)
						if (k == i) {
							// (1 1) main*softmax(-xi)	(0 1) minusone_minusxi*(softmax(+xi)-softmax(-xi))	(0 0) minusoneone*(1-softmax(+xi))
							test_case_ccon_gradient[pm][i][j] += (main_approxloss - minusone_minusxi_approxloss[nn_data->ans[pm][j]][k]) * exp(nn_data->test_case_ccon_w[pm][k][j] - xi) / mxi_expsum;
							test_case_ccon_gradient[pm][i][j] += (minusone_minusxi_approxloss[nn_data->ans[pm][j]][k] - minusoneone_approxloss[nn_data->ans[pm][j]][k]) * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum;
							test_case_ccon_gradient[pm][i][j] += -(main_approxloss - minusone_minusxi_approxloss[nn_data->ans[pm][j]][k]) * exp(nn_data->test_case_ccon_w[pm][k][j] - xi) * exp(nn_data->test_case_ccon_w[pm][i][j] - xi) / mxi_expsum / mxi_expsum;
							test_case_ccon_gradient[pm][i][j] += -(minusone_minusxi_approxloss[nn_data->ans[pm][j]][k] - minusoneone_approxloss[nn_data->ans[pm][j]][k]) * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) * exp(nn_data->test_case_ccon_w[pm][i][j] + xi) / pxi_expsum / pxi_expsum;
						}
						else {
							test_case_ccon_gradient[pm][i][j] += -(main_approxloss - minusone_minusxi_approxloss[nn_data->ans[pm][j]][k]) * exp(nn_data->test_case_ccon_w[pm][k][j] - xi) * exp(nn_data->test_case_ccon_w[pm][i][j]) / mxi_expsum / mxi_expsum;
							test_case_ccon_gradient[pm][i][j] += -(minusone_minusxi_approxloss[nn_data->ans[pm][j]][k] - minusoneone_approxloss[nn_data->ans[pm][j]][k]) * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) * exp(nn_data->test_case_ccon_w[pm][i][j]) / pxi_expsum / pxi_expsum;
						}
					}
					else if (indata->normaltable_eff[pm][k][j][1]) {
						//(0,1)
						if (k == i) {
							// (1 1) plusone_minusxi*softmax(-xi)	(0 1) main*(softmax(+xi)-softmax(-xi))	(0 0) minusone_plusxi*(1-softmax(+xi))
							test_case_ccon_gradient[pm][i][j] += (plusone_minusxi_approxloss[nn_data->ans[pm][j]][k] - main_approxloss) * exp(nn_data->test_case_ccon_w[pm][k][j] - xi) / mxi_expsum;
							test_case_ccon_gradient[pm][i][j] += (main_approxloss - minusone_plusxi_approxloss[nn_data->ans[pm][j]][k]) * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum;
							test_case_ccon_gradient[pm][i][j] += -(plusone_minusxi_approxloss[nn_data->ans[pm][j]][k] - main_approxloss) * exp(nn_data->test_case_ccon_w[pm][k][j] - xi) * exp(nn_data->test_case_ccon_w[pm][i][j] - xi) / mxi_expsum / mxi_expsum;
							test_case_ccon_gradient[pm][i][j] += -(main_approxloss - minusone_plusxi_approxloss[nn_data->ans[pm][j]][k]) * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) * exp(nn_data->test_case_ccon_w[pm][i][j] + xi) / pxi_expsum / pxi_expsum;
						}
						else {
							test_case_ccon_gradient[pm][i][j] += -(plusone_minusxi_approxloss[nn_data->ans[pm][j]][k] - main_approxloss) * exp(nn_data->test_case_ccon_w[pm][k][j] - xi) * exp(nn_data->test_case_ccon_w[pm][i][j]) / mxi_expsum / mxi_expsum;
							test_case_ccon_gradient[pm][i][j] += -(main_approxloss - minusone_plusxi_approxloss[nn_data->ans[pm][j]][k]) * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) * exp(nn_data->test_case_ccon_w[pm][i][j]) / pxi_expsum / pxi_expsum;
						}
					}
					else {
						//(0,0)
						if (k == i) {
							// (1 1) plusoneone*softmax(-xi)	(0 1) plusone_plusxi*(softmax(+xi)-softmax(-xi))	(0 0) main*(1-softmax(+xi))
							test_case_ccon_gradient[pm][i][j] += (plusoneone_approxloss[nn_data->ans[pm][j]][k] - plusone_plusxi_approxloss[nn_data->ans[pm][j]][k]) * exp(nn_data->test_case_ccon_w[pm][k][j] - xi) / mxi_expsum;
							test_case_ccon_gradient[pm][i][j] += (plusone_plusxi_approxloss[nn_data->ans[pm][j]][k] - main_approxloss) * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum;
							test_case_ccon_gradient[pm][i][j] += -(plusoneone_approxloss[nn_data->ans[pm][j]][k] - plusone_plusxi_approxloss[nn_data->ans[pm][j]][k]) * exp(nn_data->test_case_ccon_w[pm][k][j] - xi) * exp(nn_data->test_case_ccon_w[pm][i][j] - xi) / mxi_expsum / mxi_expsum;
							test_case_ccon_gradient[pm][i][j] += -(plusone_plusxi_approxloss[nn_data->ans[pm][j]][k] - main_approxloss) * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) * exp(nn_data->test_case_ccon_w[pm][i][j] + xi) / pxi_expsum / pxi_expsum;
						}
						else {
							test_case_ccon_gradient[pm][i][j] += -(plusoneone_approxloss[nn_data->ans[pm][j]][k] - plusone_plusxi_approxloss[nn_data->ans[pm][j]][k]) * exp(nn_data->test_case_ccon_w[pm][k][j] - xi) * exp(nn_data->test_case_ccon_w[pm][i][j]) / mxi_expsum / mxi_expsum;
							test_case_ccon_gradient[pm][i][j] += -(plusone_plusxi_approxloss[nn_data->ans[pm][j]][k] - main_approxloss) * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) * exp(nn_data->test_case_ccon_w[pm][i][j]) / pxi_expsum / pxi_expsum;
						}
					}
				}
			}
		}
	}

	delete new_indata;

	flatten_test_case_ccon_gradient(n_label, n_internal_test_case, n_class, test_case_ccon_gradient_list);
}